/*
 * Decompiled with CFR 0.152.
 */
package com.github.andrewoma.dexx.collection;

import com.github.andrewoma.dexx.collection.Builder;
import com.github.andrewoma.dexx.collection.BuilderFactory;
import com.github.andrewoma.dexx.collection.Function;
import com.github.andrewoma.dexx.collection.HashSet;
import com.github.andrewoma.dexx.collection.Set;
import com.github.andrewoma.dexx.collection.Traversable;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class Sets {
    private Sets() {
    }

    @NotNull
    public static <E> Set<E> of() {
        return Sets.construct(new Object[0]);
    }

    @NotNull
    public static <E> Set<E> of(E t) {
        return Sets.construct(t);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2) {
        return Sets.construct(e1, e2);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3) {
        return Sets.construct(e1, e2, e3);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4) {
        return Sets.construct(e1, e2, e3, e4);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5) {
        return Sets.construct(e1, e2, e3, e4, e5);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        return Sets.construct(e1, e2, e3, e4, e5, e6);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        return Sets.construct(e1, e2, e3, e4, e5, e6, e7);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        return Sets.construct(e1, e2, e3, e4, e5, e6, e7, e8);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        return Sets.construct(e1, e2, e3, e4, e5, e6, e7, e8, e9);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        return Sets.construct(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
    }

    @NotNull
    public static <E> Set<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E ... others) {
        Set<Object> set = Sets.construct(e1, e2, e3, e4, e5, e6, e7, e8, e9, e10);
        for (E e : others) {
            set = set.add(e);
        }
        return set;
    }

    private static <E> Set<E> construct(E ... es) {
        Set<E> set = HashSet.empty();
        for (E e : es) {
            set = set.add(e);
        }
        return set;
    }

    @NotNull
    public static <E> Set<E> copyOf(Iterable<E> iterable) {
        Set result = HashSet.empty();
        for (E e : iterable) {
            result = result.add((Object)e);
        }
        return result;
    }

    @NotNull
    public static <E> Set<E> copyOf(Iterator<E> iterator) {
        Set result = HashSet.empty();
        while (iterator.hasNext()) {
            result = result.add((Object)iterator.next());
        }
        return result;
    }

    @NotNull
    public static <E> Set<E> copyOf(E[] es) {
        Set result = HashSet.empty();
        for (E e : es) {
            result = result.add((Object)e);
        }
        return result;
    }

    @NotNull
    public static <E> Set<E> copyOfTraversable(Traversable<E> traversable) {
        final HashSet[] result = new HashSet[]{HashSet.empty()};
        traversable.forEach(new Function<E, Object>(){

            @Override
            public Object invoke(E e) {
                result[0] = result[0].add(e);
                return null;
            }
        });
        return result[0];
    }

    @NotNull
    public static <E> BuilderFactory<E, Set<E>> factory() {
        return HashSet.factory();
    }

    @NotNull
    public static <E> Builder<E, Set<E>> builder() {
        return Sets.factory().newBuilder();
    }
}

