// Copyright 2024 Mathias Bynens. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
author: Mathias Bynens
description: >
  Unicode property escapes for `Script=Nag_Mundari`
info: |
  Generated by https://github.com/mathiasbynens/unicode-property-escapes-tests
  Unicode v16.0.0
esid: sec-static-semantics-unicodematchproperty-p
features: [regexp-unicode-property-escapes]
includes: [regExpUtils.js]
---*/

const matchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x01E4D0, 0x01E4F9]
  ]
});
testPropertyEscapes(
  /^\p{Script=Nag_Mundari}+$/u,
  matchSymbols,
  "\\p{Script=Nag_Mundari}"
);
testPropertyEscapes(
  /^\p{Script=Nagm}+$/u,
  matchSymbols,
  "\\p{Script=Nagm}"
);
testPropertyEscapes(
  /^\p{sc=Nag_Mundari}+$/u,
  matchSymbols,
  "\\p{sc=Nag_Mundari}"
);
testPropertyEscapes(
  /^\p{sc=Nagm}+$/u,
  matchSymbols,
  "\\p{sc=Nagm}"
);

const nonMatchSymbols = buildString({
  loneCodePoints: [],
  ranges: [
    [0x00DC00, 0x00DFFF],
    [0x000000, 0x00DBFF],
    [0x00E000, 0x01E4CF],
    [0x01E4FA, 0x10FFFF]
  ]
});
testPropertyEscapes(
  /^\P{Script=Nag_Mundari}+$/u,
  nonMatchSymbols,
  "\\P{Script=Nag_Mundari}"
);
testPropertyEscapes(
  /^\P{Script=Nagm}+$/u,
  nonMatchSymbols,
  "\\P{Script=Nagm}"
);
testPropertyEscapes(
  /^\P{sc=Nag_Mundari}+$/u,
  nonMatchSymbols,
  "\\P{sc=Nag_Mundari}"
);
testPropertyEscapes(
  /^\P{sc=Nagm}+$/u,
  nonMatchSymbols,
  "\\P{sc=Nagm}"
);

reportCompare(0, 0);
