#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Mopi
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Yesterday
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250114.2

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='yesterday'
GAME_NAME='Yesterday'

ARCHIVE_BASE_FR_0_NAME='setup_yesterday_1.0.1_(french)_(34047).exe'
ARCHIVE_BASE_FR_0_MD5='721c746513583dbe53a5ab5ab8a2f091'
ARCHIVE_BASE_FR_0_TYPE='innosetup'
ARCHIVE_BASE_FR_0_PART1_NAME='setup_yesterday_1.0.1_(french)_(34047)-1.bin'
ARCHIVE_BASE_FR_0_PART1_MD5='ea0bfcb18f45ea25614ecd978400ec3c'
ARCHIVE_BASE_FR_0_SIZE='4300963'
ARCHIVE_BASE_FR_0_VERSION='1.0.1-gog34047'
ARCHIVE_BASE_FR_0_URL='https://www.gog.com/game/yesterday'

ARCHIVE_BASE_EN_0_NAME='setup_yesterday_1.0.1_(34047).exe'
ARCHIVE_BASE_EN_0_MD5='638c9882333cd55dabf7a136c25a5158'
ARCHIVE_BASE_EN_0_TYPE='innosetup'
ARCHIVE_BASE_EN_0_PART1_NAME='setup_yesterday_1.0.1_(34047)-1.bin'
ARCHIVE_BASE_EN_0_PART1_MD5='40aa040bcb99a2038d24266d9807aac4'
ARCHIVE_BASE_EN_0_SIZE='4304635'
ARCHIVE_BASE_EN_0_VERSION='1.0.1-gog34047'
ARCHIVE_BASE_EN_0_URL='https://www.gog.com/game/yesterday'

CONTENT_PATH_DEFAULT='.'
CONTENT_GAME_BIN_FILES='
binkw32.dll
psengine.dll
pthreadvc2.dll
psconfig.exe
yesterday.exe'
CONTENT_GAME_L10N_FILES='
dataa
resource/??
config.lang'
CONTENT_GAME_DATA_FILES='
datav
resource'

WINE_PERSISTENT_DIRECTORIES='
ProgramData/Pendulo Studios/Yesterday'
## The shipped PSEngine.dll library is linked against OpenAL32.dll.
WINE_WINETRICKS_VERBS='openal'

APP_MAIN_EXE='yesterday.exe'

PACKAGES_LIST='
PKG_BIN
PKG_L10N
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_L10N_BASE
PKG_DATA'

PKG_L10N_BASE_ID="${GAME_ID}-l10n"
PKG_L10N_ID_EN="${PKG_L10N_BASE_ID}-en"
PKG_L10N_ID_FR="${PKG_L10N_BASE_ID}-fr"
PKG_L10N_PROVIDES="
$PKG_L10N_BASE_ID"
PKG_L10N_DESCRIPTION_EN='English localization'
PKG_L10N_DESCRIPTION_FR='French localization'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
