let add_chan buf chan =
  try
    while true do
      let line = input_line chan in
      Buffer.add_string buf line;
      Buffer.add_char   buf '\n'
    done
  with End_of_file ->
    ()

let () =
  let buf = Buffer.create 1024 in
  print_endline "(* THIS FILE IS AUTOMATICALLY GENERATED, EDIT ../Makefile INSTEAD *)";
  for i = 1 to Array.length Sys.argv - 1 do
    let file = Sys.argv.(i) in
    let name =
      let file = Filename.basename file in
      if Filename.check_suffix file ".sh" then
        Filename.chop_extension file
      else
        String.map (function '.' -> '_' | c -> c) file
    in
    let c = open_in_bin file in
    Buffer.clear buf;
    add_chan buf c;
    close_in c;
    let contents = Buffer.contents buf in
    Printf.printf "let %s =\n\"%s\"\n\n"
      name
      (String.escaped contents)
  done
