/////////////////////////////////////////////////////////////////////////////////////////////
// Copyright 2024 Garmin International, Inc.
// Licensed under the Flexible and Interoperable Data Transfer (FIT) Protocol License; you
// may not use this file except in compliance with the Flexible and Interoperable Data
// Transfer (FIT) Protocol License.
/////////////////////////////////////////////////////////////////////////////////////////////
// ****WARNING****  This file is auto-generated!  Do NOT edit this file.
// Profile Version = 21.158.0Release
// Tag = production/release/21.158.0-0-gc9428aa
/////////////////////////////////////////////////////////////////////////////////////////////


#include "fit_mesg.hpp"
#include "fit_mesg_definition.hpp"
#include "fit_protocol_validator.hpp"

fit::ProtocolValidator::ProtocolValidator( ProtocolVersion version )
    : validator( nullptr )
{
    switch ( version )
    {
    case ProtocolVersion::V10:
        validator = new V1Validator();
        break;

    case ProtocolVersion::V20:
    default:
        break;
    }
}

fit::ProtocolValidator::~ProtocolValidator()
{
    if ( nullptr != validator )
    {
        delete validator;
    }
}

bool fit::ProtocolValidator::ValidateMesg( const Mesg& mesg )
{
    if ( nullptr == validator ) return true;
    return validator->ValidateMesg( mesg );
}

bool fit::ProtocolValidator::ValidateMesgDefn( const MesgDefinition& defn )
{
    if ( nullptr == validator ) return true;
    return validator->ValidateMesgDefn( defn );
}

bool fit::V1Validator::ValidateMesg( const Mesg& mesg )
{
    if ( mesg.GetDeveloperFields().size() != 0 )
    {
        return false;
    }

    for ( FIT_UINT16 i = 0; i < mesg.GetNumFields(); i++ )
    {
        const Field* fld = mesg.GetFieldByIndex( i );
        FIT_UINT8 typeNum = fld->GetType() & FIT_BASE_TYPE_NUM_MASK;

        // V2 introduces 64 bit types.
        if ( typeNum > ( FIT_BASE_TYPE_BYTE & FIT_BASE_TYPE_NUM_MASK ) )
        {
            return false;
        }
    }

    return true;
}

bool fit::V1Validator::ValidateMesgDefn( const MesgDefinition& defn )
{
    if ( defn.GetDevFields().size() != 0 )
    {
        return false;
    }

    for ( auto fld : defn.GetFields() )
    {
        FIT_UINT8 typeNum = fld.GetType() & FIT_BASE_TYPE_NUM_MASK;

        // V2 introduces 64 bit types.
        if ( typeNum > ( FIT_BASE_TYPE_BYTE & FIT_BASE_TYPE_NUM_MASK ) )
        {
            return false;
        }
    }

    return true;
}

