+++
title = "LayerStack"
weight = 36
+++

## Class LayerStack

A [Sample](/ref/sample/multilayer) or outer `LayerStack` may contain one or several instances
of class `LayerStack`.


Each instance is created using the constructor call
```python
stack = ba.LayerStack(n_periods)
```
or
```python
stack = ba.LayerStack() # by default n_periods = 1
```

The stack is created empty. To populate it with [layers](/ref/sample/multilayer/layer) or other stacks, call
```python
stack.addLayer(layer)
stack.addStack(sub_stack)
```

The numper of repetitions can be changed with
```python
stack.setNumberOfPeriods(n_periods)
```
or returned with
```python
stack.numberOfPeriods()
```

