ITK Release 2.2
===============

Introducing GDCM as DICOM reader/writer
=======================================

Until version 2.0, ITK only natively supported reading DICOM image
files. New in v2.0 is GDCM, short for “Grass roots DICOM”, a library
dedicated library for reading, parsing **and writing** DICOM image data.
[GDCM](http://www.creatis.insa-lyon.fr/Public/Gdcm/Main.html) is
developed by the [Creatis group](http://www.creatis.insa-lyon.fr/) at
INSA Lyon, France.

GDCM supports Part 5 of the DICOM standard, relating to image files (and
not the rest of the DICOM spec, such as networking, etc). The supported
formats are:

-   ACR-NEMA version 1 and 2
-   Dicom version 3.0 (including various encodings of jpeg, RLE)

Class Reference : [GDCMImageIO](http://www.itk.org/Doxygen/html/classitk_1_1GDCMImageIO.html), [GDCMSeriesFileNames](http://www.itk.org/Doxygen/html/classitk_1_1GDCMSeriesFileNames.html)\
Examples : (None)

New itkVesselTubeSpatialObject with metaIO file format to support vessel representation
=======================================================================================

New itkDTITubeSpatialObject with metaIO file format to support DTI tracts representation and reading/writing of DTI data
========================================================================================================================

This release covers the period August 10, 2004 through February 4, 2005

New Classes in this Release
---------------------------

    Code/Algorithms/itkBinaryPruningImageFilter
    Code/Algorithms/itkBinaryThinningImageFilter
    Code/Algorithms/itkBioCell
    Code/Algorithms/itkBioCellBase
    Code/Algorithms/itkBioCellularAggregate
    Code/Algorithms/itkBioCellularAggregateBase
    Code/Algorithms/itkBioGenome
    Code/Algorithms/itkEuclideanDistancePointMetr
    Code/Algorithms/itkEuclideanDistancePointMetric
    Code/Algorithms/itkKappaStatisticImageToImageMetr
    Code/Algorithms/itkKappaStatisticImageToImageMetric
    Code/Algorithms/itkOtsuMultipleThresholdsImageFilter
    Code/Algorithms/itkScalarImageKmeansImageFilter
    Code/Algorithms/itkSimplexMeshVolumeCalculator

    Code/BasicFilters/itkComplexToImaginaryImageFilter
    Code/BasicFilters/itkComplexToRealImageFilter
    Code/BasicFilters/itkConstrainedValueAdditionImageFilter
    Code/BasicFilters/itkConstrainedValueDifferenceImageFilter
    Code/BasicFilters/itkContourDirectedMeanDistanceImageFilter
    Code/BasicFilters/itkContourMeanDistanceImageFilter
    Code/BasicFilters/itkDeformationFieldJacobianDeterminantFilter
    Code/BasicFilters/itkGrayscaleMorphologicalClosingImageFilter
    Code/BasicFilters/itkGrayscaleMorphologicalOpeningImageFilter
    Code/BasicFilters/itkJoinSeriesImageFilter
    Code/BasicFilters/itkMaskNegatedImageFilter
    Code/BasicFilters/itkSignedDanielssonDistanceMapImageFilter
    Code/BasicFilters/itkSimpleContourExtractorImageFilter
    Code/BasicFilters/itkVotingBinaryHoleFillingImageFilter
    Code/BasicFilters/itkVotingBinaryImageFilter
    Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilter
    Code/BasicFilters/itkWarpMeshFilter

    Code/Common/itkComplexToImaginaryImageAdaptor
    Code/Common/itkComplexToRealImageAdaptor
    Code/Common/itkPhasedArray3DSpecialCoordinatesImage
    Code/Common/itkSimpleFilterWatcher
    Code/Common/itkSpecialCoordinatesImage
    Code/Common/itkVectorNearestNeighborInterpolateImageFunction

    Code/IO/itkArchetypeSeriesFileNames

    Code/Numerics/itkPowellOptimizer

    Code/SpatialObject/itkArrowSpatialObject
    Code/SpatialObject/itkCylinderSpatialObject
    Code/SpatialObject/itkDTITubeSpatialObject
    Code/SpatialObject/itkDTITubeSpatialObjectPoint
    Code/SpatialObject/itkMetaArrowConverter
    Code/SpatialObject/itkMetaDTITubeConverter
    Code/SpatialObject/itkMetaVesselTubeConverter
    Code/SpatialObject/itkVesselTubeSpatialObject
    Code/SpatialObject/itkVesselTubeSpatialObjectPoint

    Code/Patented/CMakeLists.txt
    Code/Patented/itkActiveShapeModelCalculator
    Code/Patented/itkActiveShapeModelGradientSearchMethod
    Code/Patented/itkSimpleFuzzyConnectednessImageFilterBase
    Code/Patented/itkSimpleFuzzyConnectednessRGBImageFilter
    Code/Patented/itkSimpleFuzzyConnectednessScalarImageFilter
    Code/Patented/itkVectorFuzzyConnectednessImageFilter

New Tests in this Release
-------------------------

    Testing/Code/Common/itkCenteredEuler3DTransformTest
    Testing/Code/Common/itkPhasedArray3DSpecialCoordinatesImageTest
    Testing/Code/Common/itkSizeTest

    Testing/Code/BasicFilters/itkComplexToImaginaryFilterAndAdaptorTest
    Testing/Code/BasicFilters/itkComplexToRealFilterAndAdaptorTest
    Testing/Code/BasicFilters/itkConstrainedValueAdditionImageFilterTest
    Testing/Code/BasicFilters/itkConstrainedValueDifferenceImageFilterTest
    Testing/Code/BasicFilters/itkContourDirectedMeanDistanceImageFilterTest
    Testing/Code/BasicFilters/itkContourMeanDistanceImageFilterTest
    Testing/Code/BasicFilters/itkDeformationFieldJacobianDeterminantFilterTest
    Testing/Code/BasicFilters/itkGrayscaleMorphologicalClosingImageFilterTest
    Testing/Code/BasicFilters/itkGrayscaleMorphologicalOpeningImageFilterTest
    Testing/Code/BasicFilters/itkJoinSeriesImageFilterTest
    Testing/Code/BasicFilters/itkMaskNegatedImageFilterTest
    Testing/Code/BasicFilters/itkResamplePhasedArray3DSpecialCoordinatesImageTest
    Testing/Code/BasicFilters/itkSignedDanielssonDistanceMapImageFilterTest
    Testing/Code/BasicFilters/itkSimpleContourExtractorImageFilterTest
    Testing/Code/BasicFilters/itkVotingBinaryHoleFillingImageFilterTest
    Testing/Code/BasicFilters/itkVotingBinaryImageFilterTest
    Testing/Code/BasicFilters/itkVotingBinaryIterativeHoleFillingImageFilterTest
    Testing/Code/BasicFilters/itkWarpMeshFilterTest

    Testing/Code/IO/itkArchetypeSeriesFileNamesTest
    Testing/Code/IO/itkImageFileWriterTest

    Testing/Code/Algorithms/itkAlgorithmsPrintTest4
    Testing/Code/Algorithms/itkAlgorithmsPrintTests
    Testing/Code/Algorithms/itkAlgorithmsTests3
    Testing/Code/Algorithms/itkBinaryThinningImageFilterTest
    Testing/Code/Algorithms/itkBioCellTest
    Testing/Code/Algorithms/itkBioCellularAggregateTest
    Testing/Code/Algorithms/itkBioGenomeTest
    Testing/Code/Algorithms/itkKappaStatisticImageToImageMetricTest
    Testing/Code/Algorithms/itkMatchCardinalityImageToImageMetricTest
    Testing/Code/Algorithms/itkOtsuMultipleThresholdsImageFilterTest
    Testing/Code/Algorithms/itkScalarImageKmeansImageFilterTest
    Testing/Code/Algorithms/itkSimplexMeshVolumeCalculatorTest

    Testing/Code/Numerics/itkPowellOptimizerTest

    Testing/Code/SpatialObject/itkArrowSpatialObjectTest
    Testing/Code/SpatialObject/itkCylinderSpatialObjectTest
    Testing/Code/SpatialObject/itkSpatialObjectTests2

    Testing/Code/Patented/CMakeLists.txt
    Testing/Code/Patented/itkActiveShapeModelCalculatorTest
    Testing/Code/Patented/itkPatentedHeaderTest
    Testing/Code/Patented/itkPatentedPrintTest
    Testing/Code/Patented/itkPatentedTests
    Testing/Code/Patented/itkSimpleFuzzyConnectednessScalarImageFilterTest
    Testing/Code/Patented/itkVectorFuzzyConnectednessImageFilterTest

New Examples in this Release
----------------------------

    Examples/DataRepresentation/Image/ImageExamples
    Examples/DataRepresentation/Mesh/MeshExamples

    Examples/Filtering/AntiAliasBinaryImageFilter
    Examples/Filtering/BinaryMedianImageFilter
    Examples/Filtering/FFTImageFilter
    Examples/Filtering/FilteringExamples3
    Examples/Filtering/FilteringExamples4
    Examples/Filtering/MorphologicalImageEnhancement
    Examples/Filtering/OtsuMultipleThresholdImageFilter
    Examples/Filtering/OtsuThresholdImageFilter
    Examples/Filtering/ResampleImageFilter7
    Examples/Filtering/ResampleImageFilter8
    Examples/Filtering/ResampleImageFilter9
    Examples/Filtering/VotingBinaryHoleFillingImageFilter
    Examples/Filtering/VotingBinaryIterativeHoleFillingImageFilter

    Examples/IO/DicomImageReadChangeHeaderWrite
    Examples/IO/DicomImageReadPrintTags
    Examples/IO/DicomImageReadWrite
    Examples/IO/DicomSeriesReadPrintTags
    Examples/IO/DicomSeriesReadSeriesWrite
    Examples/IO/DicomSliceRead.java
    Examples/IO/DicomSliceRead.py
    Examples/IO/DicomSliceRead.tcl

    Examples/Patented/CMakeLists.txt
    Examples/Patented/FuzzyConnectednessImageFilter
    Examples/Patented/HybridSegmentationFuzzyVoronoi
    Examples/Patented/IterativeClosestPoint1
    Examples/Patented/IterativeClosestPoint2
    Examples/Patented/IterativeClosestPoint3
    Examples/Patented/PatentedExamples

    Examples/Registration/DeformableRegistration7
    Examples/Registration/DeformableRegistration8
    Examples/Registration/DeformationFieldJacobian
    Examples/Registration/RegistrationExamples8

    Examples/Statistics/ImageHistogram4
    Examples/Statistics/ScalarImageKmeansClassifier
    Examples/Statistics/ScalarImageKmeansModelEstimator
    Examples/Statistics/ScalarImageMarkovRandomField1

New Utilities in this Release
-----------------------------

    Utilities/gdcm/AUTHORS
    Utilities/gdcm/ChangeLog
    Utilities/gdcm/CMakeLists.txt
    Utilities/gdcm/DEVELOPPER
    Utilities/gdcm/Dicts/CMakeLists.txt
    Utilities/gdcm/Dicts/DicomDir.d
    Utilities/gdcm/Dicts/dicomTS.d
    Utilities/gdcm/Dicts/dicomV3.d
    Utilities/gdcm/Dicts/dicomVR.d
    Utilities/gdcm/Dicts/README
    Utilities/gdcm/gdcmConfigure.h.in
    Utilities/gdcm/gdcm.spec.in
    Utilities/gdcm/INSTALL
    Utilities/gdcm/PACKAGER
    Utilities/gdcm/README
    Utilities/gdcm/README.ITK.txt
    Utilities/gdcm/src/CMakeLists.txt
    Utilities/gdcm/src/gdcm
    Utilities/gdcm/src/gdcmBinEntry
    Utilities/gdcm/src/gdcmCommon
    Utilities/gdcm/src/gdcmDebug
    Utilities/gdcm/src/gdcmDefaultDicts.cxx.in
    Utilities/gdcm/src/gdcmDicomDir
    Utilities/gdcm/src/gdcmDicomDirElement
    Utilities/gdcm/src/gdcmDicomDirImage
    Utilities/gdcm/src/gdcmDicomDirMeta
    Utilities/gdcm/src/gdcmDicomDirObject
    Utilities/gdcm/src/gdcmDicomDirPatient
    Utilities/gdcm/src/gdcmDicomDirSerie
    Utilities/gdcm/src/gdcmDicomDirStudy
    Utilities/gdcm/src/gdcmDict
    Utilities/gdcm/src/gdcmDictEntry
    Utilities/gdcm/src/gdcmDictSet
    Utilities/gdcm/src/gdcmDirList
    Utilities/gdcm/src/gdcmDocEntry
    Utilities/gdcm/src/gdcmDocEntrySet
    Utilities/gdcm/src/gdcmDocument
    Utilities/gdcm/src/gdcmElementSet
    Utilities/gdcm/src/gdcmException
    Utilities/gdcm/src/gdcmFile
    Utilities/gdcm/src/gdcmGlobal
    Utilities/gdcm/src/gdcmJpeg
    Utilities/gdcm/src/gdcmJpeg12
    Utilities/gdcm/src/gdcmJpeg16
    Utilities/gdcm/src/gdcmJpeg2000
    Utilities/gdcm/src/gdcmJpeg8
    Utilities/gdcm/src/gdcmJPEGFragment
    Utilities/gdcm/src/gdcmJPEGFragmentsInfo
    Utilities/gdcm/src/gdcmRLEFrame
    Utilities/gdcm/src/gdcmRLEFramesInfo
    Utilities/gdcm/src/gdcmSeqEntry
    Utilities/gdcm/src/gdcmSQItem
    Utilities/gdcm/src/gdcmTS
    Utilities/gdcm/src/gdcmUtil
    Utilities/gdcm/src/gdcmValEntry
    Utilities/gdcm/src/gdcmVR
    Utilities/gdcm/src/jdatadst
    Utilities/gdcm/src/jdatas
    Utilities/itkjpeg/12/CMakeLists.txt
    Utilities/itkjpeg/16/CMakeLists.txt
    Utilities/itkjpeg/8/CMakeLists.txt
    Utilities/itkjpeg/change.log
    Utilities/itkjpeg/CMakeLists.txt
    Utilities/itkjpeg/COPYRIGHT.dcmtk
    Utilities/itkjpeg/filelist.d
    Utilities/itkjpeg/install.d
    Utilities/itkjpeg/jaricom
    Utilities/itkjpeg/jcapimin
    Utilities/itkjpeg/jcapistd
    Utilities/itkjpeg/jcari
    Utilities/itkjpeg/jccoefct
    Utilities/itkjpeg/jccolor
    Utilities/itkjpeg/jcdctmgr
    Utilities/itkjpeg/jcdiffct
    Utilities/itkjpeg/jchuff
    Utilities/itkjpeg/jcinit
    Utilities/itkjpeg/jclhuff
    Utilities/itkjpeg/jclossls
    Utilities/itkjpeg/jclossy
    Utilities/itkjpeg/jcmainct
    Utilities/itkjpeg/jcmarker
    Utilities/itkjpeg/jcmaster
    Utilities/itkjpeg/jcodec
    Utilities/itkjpeg/jcomapi
    Utilities/itkjpeg/jconfig.d
    Utilities/itkjpeg/jconfig.h.in
    Utilities/itkjpeg/jcparam
    Utilities/itkjpeg/jcphuff
    Utilities/itkjpeg/jcpred
    Utilities/itkjpeg/jcprepct
    Utilities/itkjpeg/jcsample
    Utilities/itkjpeg/jcscale
    Utilities/itkjpeg/jcshuff
    Utilities/itkjpeg/jctrans
    Utilities/itkjpeg/jdapimin
    Utilities/itkjpeg/jdapistd
    Utilities/itkjpeg/jdari
    Utilities/itkjpeg/jdatadst
    Utilities/itkjpeg/jdatasrc
    Utilities/itkjpeg/jdcoefct
    Utilities/itkjpeg/jdcolor
    Utilities/itkjpeg/jdct
    Utilities/itkjpeg/jddctmgr
    Utilities/itkjpeg/jddiffct
    Utilities/itkjpeg/jdhuff
    Utilities/itkjpeg/jdinput
    Utilities/itkjpeg/jdlhuff
    Utilities/itkjpeg/jdlossls
    Utilities/itkjpeg/jdlossy
    Utilities/itkjpeg/jdmainct
    Utilities/itkjpeg/jdmarker
    Utilities/itkjpeg/jdmaster
    Utilities/itkjpeg/jdmerge
    Utilities/itkjpeg/jdphuff
    Utilities/itkjpeg/jdpostct
    Utilities/itkjpeg/jdpred
    Utilities/itkjpeg/jdsample
    Utilities/itkjpeg/jdscale
    Utilities/itkjpeg/jdshuff
    Utilities/itkjpeg/jdtrans
    Utilities/itkjpeg/jerror
    Utilities/itkjpeg/jfdctflt
    Utilities/itkjpeg/jfdctfst
    Utilities/itkjpeg/jfdctint
    Utilities/itkjpeg/jidctflt
    Utilities/itkjpeg/jidctfst
    Utilities/itkjpeg/jidctint
    Utilities/itkjpeg/jidctred
    Utilities/itkjpeg/jinclude
    Utilities/itkjpeg/jlossls
    Utilities/itkjpeg/jlossy
    Utilities/itkjpeg/jmemmgr
    Utilities/itkjpeg/jmemnobs
    Utilities/itkjpeg/jmemsys
    Utilities/itkjpeg/jmorecfg.h.in
    Utilities/itkjpeg/jpegDllConfig.h.in
    Utilities/itkjpeg/jpegint
    Utilities/itkjpeg/jpeglib
    Utilities/itkjpeg/jquant1
    Utilities/itkjpeg/jquant2
    Utilities/itkjpeg/jutils
    Utilities/itkjpeg/jversion
    Utilities/itkjpeg/libjpeg.d
    Utilities/itkjpeg/mangle_jpeg12bits
    Utilities/itkjpeg/mangle_jpeg16bits
    Utilities/itkjpeg/mangle_jpeg8bits
    Utilities/itkjpeg/.NoDartCoverage
    Utilities/itkjpeg/README
    Utilities/itkjpeg/README.GDCM.txt
    Utilities/itkjpeg/README.ITK.txt
    Utilities/itkjpeg/structure.d
    Utilities/kwsys/CommandLineArguments
    Utilities/kwsys/CommandLineArguments.hxx.in
    Utilities/kwsys/testCommandLineArguments
    Utilities/MetaIO/metaArrow
    Utilities/MetaIO/metaDTITube
    Utilities/MetaIO/metaVesselTube
    Utilities/NrrdIO/itk_NrrdIO_mangle
    Utilities/NrrdIO/.NoDartCoverage
