function oscs
    set -l command $argv[1]
    set -l cloud_name $argv[2]

    if test -z "$command"
        set command set
    end

    switch $command
        case set
            if test -z "$cloud_name"
                set -l clouds (oscs-list-clouds)
                if test (count $clouds) -eq 0
                    echo "No clouds available."
                    return 1
                end

                set -l cloud (printf "%s\n" $clouds | fzf --height 14 --layout=reverse --border --prompt="Select cloud> ")
                if test -n "$cloud"
                    set -gx OS_CLOUD $cloud
                    echo "Switched to cloud: $OS_CLOUD"
                else
                    echo "No cloud selected."
                    return 1
                end
            else
                set -l clouds (oscs-list-clouds)
                if contains -- "$cloud_name" $clouds
                    set -gx OS_CLOUD $cloud_name
                    echo "Switched to cloud: $OS_CLOUD"
                else
                    echo "Error: Cloud '$cloud_name' does not exist."
                    return 1
                end
            end
        case unset
            set -e OS_CLOUD
            echo "OS_CLOUD variable has been unset"
        case '*'
            echo "Usage: oscs {set [cloud_name] | unset}"
    end
end
