###--- >>> `kernel' <<<----- Smoothing Kernel Objects

	## alias	 help(kernel)
	## alias	 help(bandwidth.kernel)
	## alias	 help(df.kernel)
	## alias	 help(is.tskernel)
	## alias	 help(print.tskernel)
	## alias	 help(plot.tskernel)
	## alias	 help([.tskernel)

##___ Examples ___:

data(EuStockMarkets)    # Demonstrate a simple trading strategy for the 
x <- EuStockMarkets[,1]  # financial time series German stock index DAX.
k1 <- kernel("daniell", 50)  # a long moving average
k2 <- kernel("daniell", 10)  # and a short one
plot(k1) 
plot(k2)
x1 <- kernapply(x, k1)
x2 <- kernapply(x, k2)
plot(x)
lines(x1, col = "red")    # go long if the short crosses the long upwards
lines(x2, col = "green")  # and go short otherwise

data(sunspot)     # Reproduce example 10.4.3 from Brockwell and Davies (1991)
spectrum(sunspot.year, kernel=kernel("daniell", c(11,7,3)), log="no")

## Keywords: 'ts'.


