# spacebox.s creates a box plot of squared or square root difference plots...
assign("spacebox",
function(point.obj,pairs.obj,a1,a2,type='r',...) {

  if (!inherits(point.obj,"point")) stop('Point.obj must be of class, "point".\n')

  if (!inherits(pairs.obj,"pairs")) stop('Pairs.obj must be of class, "pairs".\n')

  if(missing(a1)) stop('Must enter at least one attribute.\n')
  if(missing(a2)) a2 <- a1

  a1 <- point.obj[[match(a1,names(point.obj))]]

  a2 <- point.obj[[match(a2,names(point.obj))]]

  if (type=='r') {  # square root difference cloud
    diff <- (abs(a1[pairs.obj$from]-a2[pairs.obj$to]))^0.5
    ylab <- 'square root differnece'
  }
  else {
    diff <- (a1[pairs.obj$from]-a2[pairs.obj$to])^2
    ylab <- 'squared differnece'
  }
  names_sort(unique(pairs.obj$lags))
  attr(names,'levels') <- NULL
  names <- format(names)
  boxplot(split(diff,pairs.obj$lags),
	  names=names,
	  varwidth=T)
  title(xlab='lag',
	ylab=ylab)

  return(invisible(NULL))
})
