#
assign("est.variogram",
function(point.obj,pairs.obj,a1,a2) {

#  est.variogram takes a "point" object, point.obj, and a "pairs" object, pairs.obj,
#  calculates empirical variogram estimates.


#  The result is an object of type "variogram" with 4 components: $lags, 
#  $classic, $robust, and $n.
#
#  $lags - lag category
#  $bins - distance bins for plotting
#  $classic - the classic variogram estimator
#  $robust - the robust variogram estimator
#  $med - the median estimator
#  $n - the number of pairs in the lag

  if (!inherits(point.obj,"point")) stop('Point.obj must be of class, "point".\n')

  if (!inherits(pairs.obj,"pairs")) stop('Pairs.obj must be of class, "pairs".\n')

  if(missing(a1)) stop('Must enter at least one attribute.\n')
  if(missing(a2)) a2 <- a1

  a1 <- point.obj[[match(a1,names(point.obj))]]
  a2 <- point.obj[[match(a2,names(point.obj))]]

# Allocate some space...
  lags    <- sort(unique(pairs.obj$lags))
  classic <- rep(0,length(lags))
  robust  <- rep(0,length(lags))
  med     <- rep(0,length(lags))
  n       <- rep(0,length(lags))

  diff <- a1[pairs.obj$from]-a2[pairs.obj$to]
  bo   <- split(diff,pairs.obj$lags)

# this fails sometimes:
#  tmp<-unique(pairs.obj$lags[-which.na(pairs.obj$lags)])
# so do this:
  if (any(is.na(pairs.obj$lags))) 
     tmp <- unique(pairs.obj$lags[-which.na(pairs.obj$lags)])
  else 
     tmp <- unique(pairs.obj$lags)

  for (i in c(1:length(tmp))) {
#  for (i in unique(pairs.obj$lags)) {
    n[i] _ length(bo[[i]][!is.na(bo[[i]])])

#   classic, see Matheron
    classic[i] <- sum((bo[[i]])^2,na.rm=T) / n[i]

#   robust & med, see Cressie, 1990
    robust[i] <- (sum(abs(bo[[i]])^.5,na.rm=T) / n[i] )^4 / (0.457 + (0.494/n[i]))
    med[i] <- (median(abs(bo[[i]])^.5,na.rm=T))^4 / (0.457 + (0.494/n[i]))
#    med[i] <- median(abs(bo[[i]]),na.rm=T)
  }    
  o.variogram <- data.frame(lags,bins=c(pairs.obj$bins,recursive=T),classic,
                      robust,med,n=n)
  class(o.variogram) <- c("variogram","data.frame")
  return(o.variogram)

})

provide(sgeostat)
